---
title: Troubleshooting · Cloudflare Automatic Platform Optimization docs
description: The WordPress plugin may go undetected on your Cloudflare dashboard
  for a few reasons.
lastUpdated: 2025-05-08T20:05:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/automatic-platform-optimization/troubleshooting/
  md: https://developers.cloudflare.com/automatic-platform-optimization/troubleshooting/index.md
---

## WordPress plugin is undetected on Cloudflare dashboard

The WordPress plugin may go undetected on your Cloudflare dashboard for a few reasons.

* Versions older than 3.8.2 of the WordPress plugin are installed.
  * **Solution:** Install version 4.4.0 of the WordPress plugin.
* Version 3.8.2 of the plugin is installed but existing cache plugins return stale responses, for example, without `cf-edge-cache` header.
  * **Solution:** Enable APO from the WordPress plugin and purge the cache in the existing cache plugins.
* WordPress only runs on a subdomain, but WordPress and the WordPress plugin check against the apex domain.
  * **Solution:** For additional information, see [Subdomains and subdirectories](https://developers.cloudflare.com/automatic-platform-optimization/reference/subdomain-subdirectories/)

If your Cloudflare dashboard cannot detect the WordPress plugin after trying the solutions above, ensure you completed all of the steps listed in [Activate the Cloudflare WordPress plugin](https://developers.cloudflare.com/automatic-platform-optimization/get-started/activate-cf-wp-plugin/).

Note

The Cloudflare APO WordPress plugin does not support multisite WordPress installation.

## WordPress returns stale content

If WordPress is returning stale content, [purge the cache](https://developers.cloudflare.com/cache/how-to/purge-cache/) when APO is enabled.
